/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.parsing;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.html.parsing.HTMLDocumentTypes;
import com.aptana.parsing.ParseState;
import com.aptana.parsing.lexer.IRange;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class HTMLParseState
extends ParseState {
    private static final Set<String> END_OPTIONAL_TAGS = CollectionsUtil.newSet((Object[])new String[]{"body", "colgroup", "dd", "dt", "area", "html", "li", "option", "p", "tbody", "td", "tfoot", "th", "thead", "tr"});
    private static final Set<String> END_FORBIDDEN_OR_EMPTY_TAGS = CollectionsUtil.newSet((Object[])new String[]{"area", "base", "basefont", "br", "col", "frame", "hr", "img", "input", "isindex", "link", "meta", "param", "track"});
    private HTMLDocumentTypes.Type fDocumentType;
    private static final Map<String, Integer> fEndTagInfo = new HashMap<String, Integer>(END_OPTIONAL_TAGS.size() + END_FORBIDDEN_OR_EMPTY_TAGS.size());

    static {
        for (String tag : END_OPTIONAL_TAGS) {
            fEndTagInfo.put(tag, 2);
        }
        for (String tag : END_FORBIDDEN_OR_EMPTY_TAGS) {
            fEndTagInfo.put(tag, 12);
        }
    }

    public HTMLParseState(String source) {
        this(source, 0);
    }

    public HTMLParseState(String source, int startingOffset) {
        this(source, startingOffset, null);
    }

    public HTMLParseState(String source, int startingOffset, IRange[] ranges) {
        super(source, startingOffset, ranges);
        this.fDocumentType = HTMLDocumentTypes.getType(source);
    }

    public HTMLDocumentTypes.Type getDocumentType() {
        return this.fDocumentType;
    }

    public int getCloseTagType(String tagName) {
        int info;
        int type;
        String key = tagName.toLowerCase();
        if (fEndTagInfo.containsKey(key) && ((type = (info = fEndTagInfo.get(key).intValue()) & 7) == 4 || this.fDocumentType.compareTo(HTMLDocumentTypes.Type.XHTML_1_0_STRICT) < 0)) {
            return type;
        }
        return 1;
    }

    public static boolean isEmptyTagType(String tagName) {
        String key = tagName.toLowerCase();
        if (fEndTagInfo.containsKey(key)) {
            return (fEndTagInfo.get(key) & 8) == 8;
        }
        return false;
    }

    public static boolean isEndForbiddenOrEmptyTag(String name) {
        return END_FORBIDDEN_OR_EMPTY_TAGS.contains(name);
    }
}

